/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'Magento_Captcha/js/view/checkout/defaultCaptcha',
    'Magento_Captcha/js/model/captchaList',
    'underscore',
    'Magento_Checkout/js/model/payment/set-payment-hooks'
],
function (defaultCaptcha, captchaList, _, setPaymentHooks) {
    'use strict';

    return defaultCaptcha.extend({
        /** @inheritdoc */
        initialize: function () {
            var self = this,
                currentCaptcha;

            this._super();
            currentCaptcha = captchaList.getCaptchaByFormId(this.formId);

            if (currentCaptcha != null) {
                currentCaptcha.setIsVisible(true);
                this.setCurrentCaptcha(currentCaptcha);
                setPaymentHooks.requestModifiers.push(function (headers) {
                    if (self.isRequired()) {
                        headers['X-Captcha'] = self.captchaValue()();
                    }
                });
                setPaymentHooks.afterRequestListeners.push(function () {
                    self.refresh();
                });
            }
        }
    });
});
